/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgmUtils;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50Partition;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecLparsUpdater {
    private OmCecMgr mCecMgr;
    private RObject mCecObj;
    private FspCmdHelper mCmdHelper;
    private PIHMCSaveArea mSaveArea;

    public OmCecLparsUpdater(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
        this.mCmdHelper = this.mCecMgr.getCmdHelper();
    }

    public boolean update() throws RException, PIHscServerException, PIHscCmdMgrException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        UnsignedInt8 unsignedInt8;
        boolean bl = false;
        this.mCecObj = this.mCecMgr.getObject();
        this.mSaveArea = this.mCecMgr.getSaveArea();
        Map map = null;
        if (this.mCecMgr.isHypervisorRunning()) {
            map = this.mCmdHelper.getDefinedSlotStates();
        }
        String[] stringArray = this.mSaveArea.getAllPartitionNames();
        int n2 = stringArray.length;
        System.out.println("numOfLparSlots=" + n2);
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            bl2 = true;
            break;
        }
        if (this.mCecMgr.isHypervisorRunning() && (unsignedInt8 = (UnsignedInt8)this.mCecMgr.getProperty("Mode")) != null && unsignedInt8.intValue() == 0) {
            Object object5;
            if (bl2) {
                object5 = this.mCmdHelper.getLparUserDefName(new UnsignedInt16(1));
                if (!((String)object5).equals(stringArray[0])) {
                    this.mCmdHelper.setLparName(new UnsignedInt16(1), stringArray[0]);
                }
            } else {
                object5 = new OmCecMgmUtils(this.mCecMgr);
                stringArray[0] = object4 = ((OmCecMgmUtils)object5).createMgmPartition();
            }
        }
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1;
            object3 = new UnsignedInt16(n3);
            if (stringArray[i] != null && !stringArray[i].equals("")) {
                System.out.println("++++++++ lpar found: " + n3 + " [" + stringArray[i] + "]");
                hashtable.put(object3, stringArray[i]);
                if (map == null) continue;
                object2 = null;
                object2 = (UnsignedInt8)map.get(object3);
                if (object2 == null || object2.intValue() == 0) {
                    System.out.println("++++ lpar " + n3 + " found in SaveArea but not defined in FSP");
                    System.out.println("put cec into recovery state");
                    this.mCecMgr.setCecRecoveryState();
                    throw new PIHscServerException("0006", null);
                }
                int n4 = object2.intValue();
                n = 1;
                if (130 == n4 || 129 == n4) {
                    n = 129;
                } else if (66 == n4 || 65 == n4) {
                    n = 4;
                } else if (4 == n4 || 3 == n4) {
                    n = 65;
                }
                if (this.mSaveArea.getPartitionOsType(n3) == n) continue;
                System.out.println("lpar " + n3 + " osType mismatched");
                System.out.println("lpar " + n3 + " at FSP: " + n);
                System.out.println("lpar " + n3 + " at SaveArea: " + this.mSaveArea.getPartitionOsType(n3));
                System.out.println("put cec into recovery state");
                this.mCecMgr.setCecRecoveryState();
                throw new PIHscServerException("0006", null);
            }
            if (map == null) continue;
            object2 = null;
            object2 = (UnsignedInt8)map.get(object3);
            if (object2 == null || object2.intValue() == 0) continue;
            System.out.println("++++ lpar " + n3 + " not defined in save area");
            System.out.println("partitions in FSP differ from partitions in the save area.");
            System.out.println("put cec into recovery state");
            this.mCecMgr.setCecRecoveryState();
            throw new PIHscServerException("0006", null);
        }
        Vector vector = this.mCecObj.associatorNames(R50Define.AID_IBMHSC_CompSysPartition);
        if (vector != null) {
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                object3 = (RObjectId)object4.nextElement();
                object2 = ((RObjectId)object3).getObject();
                String string = (String)((RObject)object2).getProperty(R50Partition.Index_Name);
                n = Integer.parseInt(string.substring(0, string.indexOf("*")));
                object = new UnsignedInt16(n);
                String string2 = (String)hashtable.get(object);
                if (string2 == null) {
                    System.out.println("[OM] no longer existing partition: " + string);
                    this.mCecMgr.deleteLpar(string, false);
                    continue;
                }
                OmLparMgr omLparMgr = this.mCecMgr.getLparMgr(string);
                if (omLparMgr == null) {
                    omLparMgr = this.mCecMgr.createLparMgr(string, string2);
                    if (!this.mCecMgr.isHypervisorRunning()) {
                        omLparMgr.setInitState();
                    }
                    omLparMgr.setSentCreationEvent();
                    omLparMgr.updateLparAll();
                    this.mCecMgr.addLparMgr(omLparMgr);
                } else {
                    System.out.println("[OM] existing partition: " + string);
                    omLparMgr.updateLparAll();
                }
                hashtable.remove(object);
            }
        }
        object4 = hashtable.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (UnsignedInt16)object4.next();
            object2 = (String)hashtable.get(object3);
            StringBuffer stringBuffer = new StringBuffer(object3.toString());
            stringBuffer.append("*").append(this.mCecMgr.getCecName());
            String string = stringBuffer.toString();
            object = this.mCecMgr.createLparMgr(string, (String)object2);
            if (!this.mCecMgr.isHypervisorRunning()) {
                ((OmLparMgr)object).setInitState();
            }
            System.out.println("[OM] new partition: " + string);
            ((OmLparMgr)object).updateLparAll();
            this.mCecMgr.addLparMgr((OmLparMgr)object);
            bl = true;
        }
        return bl;
    }
}

